/*
 * Decompiled with CFR 0.152.
 */
package com.intellijava.com.intellijava.core.controller;

import com.intellijava.com.intellijava.core.model.OpenaiImageResponse;
import com.intellijava.com.intellijava.core.wrappers.OpenAIWrapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class RemoateImageModel {
    private String keyType;
    private OpenAIWrapper openaiWrapper;

    public RemoateImageModel(String keyValue, String keyType) {
        if (keyType != "" && keyType != "openai") {
            throw new IllegalArgumentException("This version support openai keyType only");
        }
        this.keyType = "openai";
        this.openaiWrapper = new OpenAIWrapper(keyValue);
    }

    public List<String> generateImages(String prompt, int numberOfImages, String imageSize) throws IOException {
        if (this.keyType == "openai") {
            return this.generateOpenaiImage(prompt, numberOfImages, imageSize);
        }
        throw new IllegalArgumentException("This version support openai keyType only");
    }

    private List<String> generateOpenaiImage(String prompt, int numberOfImages, String imageSize) throws IOException {
        ArrayList<String> images = new ArrayList<String>();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("prompt", prompt);
        params.put("n", numberOfImages);
        params.put("size", imageSize);
        OpenaiImageResponse resModel = (OpenaiImageResponse)this.openaiWrapper.generateImages(params);
        List<OpenaiImageResponse.Data> responseImages = resModel.getData();
        for (OpenaiImageResponse.Data data : responseImages) {
            images.add(data.getUrl().toString());
        }
        return images;
    }
}

