/*
 * Decompiled with CFR 0.152.
 */
package com.intellijava.com.intellijava.core.controller;

import com.intellijava.com.intellijava.core.model.OpenaiLanguageResponse;
import com.intellijava.com.intellijava.core.wrappers.OpenAIWrapper;
import java.io.IOException;
import java.util.HashMap;

public class RemoteLanguageModel {
    private String keyType;
    private OpenAIWrapper openaiWrapper;

    public RemoteLanguageModel(String keyValue, String keyType) {
        if (keyType != "" && keyType != "openai") {
            throw new IllegalArgumentException("This version support openai keyType only");
        }
        this.keyType = "openai";
        this.openaiWrapper = new OpenAIWrapper(keyValue);
    }

    public String generateText(String model, String prompt, float temperature, int maxTokens) throws IOException {
        if (this.keyType == "openai") {
            return this.generateOpenaiText(model, prompt, temperature, maxTokens);
        }
        throw new IllegalArgumentException("This version support openai keyType only");
    }

    private String generateOpenaiText(String model, String prompt, float temperature, int maxTokens) throws IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("model", model);
        params.put("prompt", prompt);
        params.put("temperature", Float.valueOf(temperature));
        params.put("max_tokens", maxTokens);
        OpenaiLanguageResponse resModel = (OpenaiLanguageResponse)this.openaiWrapper.generateText(params);
        return resModel.getChoices().get(0).getText();
    }
}

