/*
 * Decompiled with CFR 0.152.
 */
package com.intellijava.com.intellijava.core.utils;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.nio.charset.StandardCharsets;
import java.util.Map;

public class ConnHelper {
    private static Gson gson = new Gson();

    public static String convertMaptToJson(Map<String, Object> params) {
        return gson.toJson(params);
    }

    public static <T> T convertSteamToModel(InputStream stream, Class<T> classOfT) {
        InputStreamReader streamReader = new InputStreamReader(stream, StandardCharsets.UTF_8);
        Object resModel = gson.fromJson((Reader)streamReader, classOfT);
        return (T)resModel;
    }

    public static String getErrorMessage(HttpURLConnection connection) throws IOException {
        String apiErrorMessage = ConnHelper.readStream(connection.getErrorStream());
        String errorMessage = "Unexpected HTTP response: " + connection.getResponseCode();
        if (apiErrorMessage != null) {
            errorMessage = errorMessage + " Error details:" + apiErrorMessage;
        }
        return errorMessage;
    }

    public static String readStream(InputStream stream) throws IOException {
        StringBuilder result = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream));){
            String line;
            while ((line = reader.readLine()) != null) {
                result.append(line);
            }
        }
        return result.toString();
    }
}

